#!/bin/bash
# adapted from https://github.com/pfoo/armbian-lib/blob/master/scripts/update-motd.d/30-sysinfo

function display() {
	# $1=name $2=value $3=red_limit $4=minimal_show_limit $5=unit $6=after $7=acs/desc{
	# battery red color is opposite, lower number
	if [[ "$1" == "Battery" ]]; then local great="<"; else local great=">"; fi
	#if [[ -n "$2" && "$2" -gt "0" && (( "${2%.*}" -ge "$4" )) ]]; then
		printf "%-14s" "$1:"
		if awk "BEGIN{exit ! ($2 $great $3)}"; then echo -ne "\e[0;91m $2"; else echo -ne "\e[0;92m $2"; fi
		printf "%-1s\x1B[0m" "$5"
		printf "%-11s\t" "$6"
		return 1
	#fi
} # display

# memory and swap
mem_info=$(LC_ALL=C free -w 2>/dev/null | grep "^Mem" || LC_ALL=C free | grep "^Mem")
memory_usage=$(awk '{printf("%.0f",(($2-($4+$6+$7))/$2) * 100)}' <<<${mem_info})
mem_info=$(echo $mem_info | awk '{print $2}')
memory_total=$(( mem_info / 1024 ))
swap_info=$(LC_ALL=C free -m | grep "^Swap")
swap_usage=$( (awk '/Swap/ { printf("%3.0f", $3/$2*100) }' <<<${swap_info} 2>/dev/null || echo 0) | tr -c -d '[:digit:]')
swap_total=$(awk '{print $(2)}' <<<${swap_info})

if [[ ${memory_total} -gt 1000 ]]; then
	memory_total=$(awk '{printf("%.2f",$1/1024)}' <<<${memory_total})"G"
else
	memory_total+="M"
fi

if [[ ${swap_total} -gt 500 ]]; then
	swap_total=$(awk '{printf("%.2f",$1/1024)}' <<<${swap_total})"G"
else
	swap_total+="M"
fi

display "Memory usage" "$memory_usage" "70" "0" "%" " of ${memory_total}"
echo "" # fixed newline
display "Zram usage" "$swap_usage" "75" "0" "%" " of ${swap_total}"
echo "" # fixed newline