#!/bin/bash
# Increases post character limit on mastodon docker container
# Run from the same dir as the docker-compose.yaml file
# https://gist.github.com/adlerweb/ccc6323b77148cad06fff98c232e6212
POST_LIMIT=${1:-2000}

docker compose exec --user=root web sed -i "s/max_characters'], [0-9]\+/max_characters'], $POST_LIMIT)/g" app/javascript/mastodon/features/compose/containers/compose_form_container.js
docker compose exec --user=root web sed -i "s/MAX_CHARS = [0-9]\+/MAX_CHARS = $POST_LIMIT/g" app/validators/status_length_validator.rb
docker compose exec --user=root web bundle exec rails assets:precompile

docker compose restart web